<?php
// this is a generic script you can put into a directory of images and it will just play ( given that you have installed the Paradigm TV extension & its TV app ).

// get an array image files in this directory and from the "GET" variable determine the next image 
$files = glob( "{*.jpg,*.JPG}", GLOB_BRACE );	// case aware .. note that this will miss files that have an extension like "jPg"
$n = sizeof( $files );

$nextPic = isset( $_GET['nextPic'] ) ? $_GET['nextPic'] : 0;
$nextPic= $nextPic % $n;
if( $nextPic < 0 )
	$nextPic = $n + $nextPic;

// get my directory 
$pathParts = preg_split( "/\//", $_SERVER["PHP_SELF"] );
$pathParts[ sizeof( $pathParts ) - 1 ] = "";	// get rid of 'index.php'
$myDir = implode("/", $pathParts );

$imageToShow = "http://" . $_SERVER["SERVER_NAME"] . $myDir . $files[ $nextPic % $n ];	// build the URL for the image to show

if( isset( $_GET['service'] ) ) {		// if the tv is asking for service then...
	echo rawurlencode($imageToShow);	// give the TV the URL to the image file
	exit(0);
} else if( isset( $_GET['status_check'] ) ) {	// let tv know everything is ok here. This is mandatory for slide server.
	echo "ok";	// tell the TV that the connection to this server is good
	exit(0);
}
?>
<HTML>
<HEAD>
<TITLE>The Designer Science Sample Slide show player for Paradigm TV</TITLE>
<script language="JavaScript">
function play_this( image )
{
	var urlObject = document.getElementById( 'DSTV_URL_TO_PLAY' );
	urlObject.value = image;	// this sends the full image path to your TV
}
alert( "http://<?php echo $_SERVER['SERVER_NAME'] . $_SERVER['PHP_SELF'];?>?autoPlay=1&play=1" );
</script>
</HEAD>
<BODY>

<!-- these inputs are needed for communicating with the extension -->
<input type=hidden id='DSTV_MEDIA_TITLE' value="http://www.designerscience.com" >
<input type=hidden id= 'DSTV_URL_TO_PLAY' value="http://www.designerscience.com" >
<input type=hidden id= 'DSTV_NEXT' value="http://<?php echo $_SERVER['SERVER_NAME'] . $_SERVER['PHP_SELF'];?>?autoPlay=1&play=1" ><!-- to tell the tv where to get the images and allow autoplay on startup and start playing this slide show now -->

<button onclick="play_this( '<?php echo $imageToShow;?>' )">Play</button><br>
<img src="<?php echo $files[0];?>" width=640 height=480><!-- just put up a poster image to show that you're at the right place -->
</BODY>
</HTML>
